/*
 * Decompiled with CFR 0.152.
 */
package test.digitize;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;

public class FrankenApp {
    public static Map<String, List> edgeDetection(QDataSet spectra_trim, List<Integer> time_index, List<Integer> freq_index) {
        int r = 0;
        int t = time_index.get(0);
        QDataSet span = spectra_trim.slice(0);
        ArrayList<String> tags = new ArrayList<String>();
        double low = Ops.total((QDataSet)span.trim(freq_index.get(r) - 2, freq_index.get(r) + 1));
        double high = Ops.total((QDataSet)span.trim(freq_index.get(r) + 1, freq_index.get(r) + 2 + 1));
        double threshold = (float)((high + low) / 2.0);
        System.err.println("low=" + low);
        System.err.println("high=" + high);
        System.err.println("thresh=" + threshold);
        for (int islice = 0; islice < spectra_trim.length(); ++islice) {
            int avg;
            int i;
            QDataSet s = spectra_trim.slice(islice);
            ArrayList<Integer> collect = new ArrayList<Integer>();
            collect.add(freq_index.get(r));
            for (i = 0; i < 10 && Ops.log10((double)s.value(freq_index.get(r) + i + 1)) >= Ops.log10((double)s.value(freq_index.get(r) + i)); ++i) {
                collect.add(freq_index.get(r) + i + 1);
            }
            for (i = -9; i < 1 && Ops.log10((double)s.value(freq_index.get(r) + i - 1)) <= Ops.log10((double)s.value(freq_index.get(r) + i)); ++i) {
                collect.add(freq_index.get(r) + i + 1);
            }
            int avg_freq = (int)Ops.round((QDataSet)Ops.divide((Object)Ops.total(collect), (Object)collect.size())).value();
            low = Ops.total((QDataSet)s.trim(freq_index.get(r) - 2, freq_index.get(r) + 1));
            high = Ops.total((QDataSet)s.trim(freq_index.get(r) + 1, freq_index.get(r) + 2 + 1));
            double ratio = (high + low) / 2.0;
            if (ratio > threshold) {
                if (freq_index.get(r) - 1 != avg_freq) {
                    avg = (int)((double)(freq_index.get(r) - 1 + avg_freq) / 2.0);
                    freq_index.add(avg);
                } else {
                    freq_index.add(avg_freq);
                }
            } else if (freq_index.get(r) + 1 != avg_freq) {
                avg = (int)((double)(freq_index.get(r) + 1 + avg_freq) / 2.0);
                freq_index.add(avg);
            } else {
                freq_index.add(avg_freq);
            }
            time_index.add(t);
            tags.add("fpe");
            tags.add("edit");
            ++r;
            ++t;
        }
        time_index = time_index.subList(0, time_index.size());
        freq_index = freq_index.subList(0, time_index.size());
        HashMap<String, List> result = new HashMap<String, List>();
        result.put("time_index", time_index);
        result.put("freq_index", freq_index);
        result.put("tags", tags);
        return result;
    }
}

